% prodigal.mm -- the fable of the prodigal son with parallel
%                transcription and translation, taken from Grierson.
%
% History:
%   04-MAY-1998 changed transcription (JH)
%   26-JAN-1996 removed overfull rules
%   23-NOV-1995 Updated for new transcription scheme (JH)
%   07-FEB-1993 Created (Jeroen Hellingman)

\input mmmacs
\input mmtrmacs
\input twolines

\overfullrule=0pt

\def\malstrut{\leavevmode\lower6pt\vbox to20pt{}}
\def\firststyle{\malstrut}
\def\secondstyle{\rm}
\def\thirdstyle{\it}

\raggedbottom
\emergencystretch=40pt
\parindent=0pt

\centerline{$$^^malayaa.lam^^$$}
\bigskip

\beginthreelines

[$oru$|$$^oru$$|One] [$manu.syannu$|$$manu.syannu$$|man-to]
[$ra.n.tu$|$$ra.n.du$$|two] [$makka.l$|$$makka.l$$|sons]
[$u.n.taayirunnu.$|$$u.n.d-aay-irunnu.$$|having-become-were.]
[$atil$|$$^adil$$|That-in] [$i.layavan$|$$i.layavan$$|the-younger]
[$appanoo.tu,$|$$appanoo.du,$$|the-father-to,]
[$`appaa,$|$$`appaa,$$|`father,]
[$vastukka.lil$|$$vastu-kka.lil$$|goods-in] [$enikku$|$$enikku$$|me-to]
[$varee.n.tunna$|$$var-ee.n.dunna$$|coming] [$pa"nku$|$$pa"ngu$$|share]
[$taree.namee,'$|$$tar-ee.nam-ee,'$$|give-should,']
[$ennu$|$$ennu$$|having-said] [$pa.ru~n~nu,$|$$pa.ru~n~nu,$$|said,]
[$avanum$|$$avan-um$$|he-and] [$mutaline$|$$mudaline$$|property]
[$avarkku$|$$avarkku$$|them-to]
[$pakuti ceytu.$|$$pagudi-ceydu.$$|share-made.]
%
[$ee.re$|$$^ee.re$$|Many] [$naal$|$$naal$$|days]
[$kazhiyum$|$$kazhiyum$$|passing] [$munpe$|$$mumbe$$|before]
[$i.laya$|$$i.laya$$|younger] [$makan$|$$makan$$|son]
[$sakalavum$|$$sakalavum$$|all]
[$svaruupiccuko.n.tu$|$$svaruupiccu-ko.n.du$$|having-collected-for-himself]
[$duura$|$$duura$$|far]
[$deeshatteekku$|$$deeshatteekku$$|country-to]
[$yaatra$|$$yaatra$$|journey] [$pooyi$|$$pooyi$$|having-gone]
[$avi.te$|$$avi.de$$|there]
[$durnna.tappaayi$|$$durnna.dapp-aayi$$|bad-conduct-becoming]
[$jiiviccu$|$$jiiviccu$$|having-lived]
[$tan.re$|$$tan.re$$|his] [$vastu$|$$vastu$$|property]
[$naanaavidham$|$$naanaavidham$$|in-various-ways]
[$aakkikka.la~n~nu.$|$$aakki-kka.la~n~nu.$$|made-wasted.]
%
[$ellaam$|$$^ellaam$$|All]
[$celavazhicca$|$$celavazhicca$$|spent] [$shee.sam$|$$shee.sam$$|after]
[$aa$|$$aa$$|that] [$deeshattil$|$$deeshattil$$|country-in]
[$ka.thina$|$$ka.thina$$|severe] [$k.saamam$|$$k.saamam$$|famine]
[$u.n.taayi.t.tu$|$$u.n.daay-i.t.tu$$|having-become]
[$avannu$|$$avannu$$|him-to] [$mu.t.tu$|$$mu.t.tu$$|want]
[$vannu$|$$vannu$$|coming] [$tu.ta"n"ni.$|$$tu.da"n"ni.$$|began.]
%
[$ennaa.re$|$$^ennaa.re$$|Then] [$avan$|$$avan$$|he]
[$pooyi$|$$pooyi$$|having-gone] [$aa$|$$aa$$|that]
[$deeshattilee$|$$deeshattil-ee$$|country-in-being]
[$pauranmaaril$|$$pauranmaaril$$|citizens-among]
[$oruttanoo.tu$|$$oruttanoo.du$$|one-with]
[$pa.r.rikko.n.tu$|$$pa.r.ri-kko.n.du$$|joining-himself]
[$aayavan$|$$aay-avan$$|having-become-he]
[$avane$|$$avane$$|him] [$tan.re$|$$tan.re$$|his]
[$nila"n"na.lil$|$$nila"n"na.lil$$|fields-in]
[$pannika.le$|$$panniga.le$$|pigs] [$meeypaan$|$$meeypaan$$|to-feed]
[$ayaccu.$|$$ayaccu.$$|sent.]
%
[$pannika.l$|$$^panniga.l$$|Pigs] [$tinnunna$|$$tinunna$$|eating]
[$marappaya.ru$|$$marappaya.ru$$|husk] [$ko.n.tu$|$$ko.n.du$$|taking]
[$tan.re$|$$tan.re$$|his] [$vaya.ru$|$$vaya.ru$$|belly]
[$ni.reppaan$|$$ni.reppaan$$|to-fill]
[$avan$|$$avan$$|he] [$aagrahiccu$|$$aagrahiccu$$|wished]
[$e"nkilum$|$$e"ngilum$$|though] [$aarum$|$$aar-um$$|anybody]
[$avannu$|$$avannu$$|him-to] [$ko.tuttilla.$|$$ko.dutt-illa.$$|gave-not.]
%
[$appoo.l$|$$^appoo.l$$|Then] [$buddhi$|$$buddhi$$|sense]
[$te.li~n~ni.t.tu$|$$te.li~n~ni.t.tu$$|having-cleared] [$avan$|$$avan$$|he]
[$pa.ra~n~nu,$|$$pa.ra~n~nu,$$|said,] [$`en.re$|$$`en.re$$|`my]
[$appan.re$|$$appan.re$$|father-of] [$etra$|$$etra$$|how-many]
[$kuulikkaar$|$$kuulikkaar$$|servants] [$appam$|$$appam$$|bread]
[$tinnu$|$$tinnu$$|having-eaten]
[$shee.sippikkunnu.n.tu$|$$shee.sippikkunn-u.n.du$$|saving-are]
[$~naanoo$|$$~naan-oo$$|I-but] [$vishappu$|$$vishappu$$|hunger]
[$ko.n.tu$|$$ko.n.du$$|taking]
[$nashiccupookunnu.$|$$nashiccu-poogunnu.$$|perishing-go.]
%
[$~naan$|$$^~naan$$|I] [$ezhunii.r.ru$|$$ezhunii.r.ru$$|having-arisen]
[$en.re$|$$en.re$$|my] [$appan.re$|$$appan.re$$|father's]
[$a.tukkaleekku$|$$a.dukkaleekku$$|presence-to]
[$pooyi$|$$pooyi$$|going] [$avanoo.tu,$|$$avanoo.du,$$|him-to,]
[$``appaa,$|$$``appaa,$$|``father,] [$~naan$|$$~naan$$|I]
[$svarggattoo.tum$|$$svarggattoo.d-um$$|heaven-to-and]
[$ninnoo.tum$|$$ninnoo.dum$$|thee-to-and] [$paapam$|$$paapam$$|sin]
[$ceytu.$|$$ceydu.$$|did.]
%
[$ini$|$$^ini$$|Hereafter] [$nin.re$|$$nin.re$$|thy]
[$makan$|$$magan$$|son] [$ennu$|$$ennu$$|saying]
[$vi.likkappe.tuvaan$|$$vi.likka-ppe.duvaan$$|to-be-called]
[$yoogyanalla.$|$$yoogyan-alla.$$|fit-man-am-not.]
%
[$nin.re$|$$^nin.re$$|Thy] [$kuulikkaaril$|$$kuulikkaaril$$|servants-among]
[$oruttane$|$$oruttane$$|one] [$poole$|$$poole$$|like]
[$enne$|$$enne$$|me]
[$aakkikko.l.lee.namee,''$|$$aakki-kko.l.l-ee.nam-ee,''$$|having-made-to-take-is-wanted,'']
[$ennu$|$$ennu$$|saying] [$pa.rayum.'$|$$pa.rayum.'$$|shall-say.']
%
[$enni.t.tu$|$$^enni.t.tu$$|Having-said]
[$ezhunii.r.ru$|$$ezhunii.r.ru$$|having-arisen]
[$tan.re$|$$tan.re$$|his] [$appan.re$|$$appan.re$$|father's]
[$a.tukkaleekku$|$$a.dukkaleeku$$|presence-to] [$pooyi.$|$$pooyi.$$|went.]
%
[$avan$|$$^avan$$|He]
[$duurattu.l.lappoo.l$|$$duurattu.l.l-appool$$|far-being-time-at]
[$tannee$|$$tannee$$|indeed] [$appan$|$$appan$$|the-father]
[$avane$|$$avane$$|him] [$ka.n.tu$|$$ka.n.du$$|seeing]
[$kara.lali~n~nu$|$$kara.l-ali~n~nu$$|heart-melting]
[$oo.ticcennu$|$$oo.di-ccennu$$|running-going] [$avan.re$|$$avan.re$$|his]
[$kazhuttil$|$$kazhuttil$$|neck-on]
[$ke.t.tippi.ticcu$|$$ke.t.tippi.diccu$$|having-attached-seized]
[$avane$|$$avane$$|him]
[$cunpiccu.$|$$cumbiccu.$$|kissed.]
%
[$makan$|$$^magan$$|The-son] [$avanoo.tu,$|$$avanoo.du,$$|him-to,]
[$`appaa,$|$$`appaa,$$|`father,] [$~naan$|$$~naan$$|I]
[$svarggattoo.tum$|$$svarggattoo.d-um$$|heaven-to-and]
[$ninnoo.tum$|$$ninnoo.dum$$|thee-to-and] [$paapam$|$$paapam$$|sin]
[$ceytu.$|$$ceydu.$$|did.]
%
[$ini$|$$^ini$$|Hereafter] [$nin.re$|$$nin.re$$|thy]
[$makan$|$$magan$$|son] [$ennu$|$$ennu$$|saying]
[$vi.likkappe.tuvaan$|$$vi.likka-ppe.duvaan$$|to-be-called]
[$yoogyanumalla,'$|$$yoogyan-um-alla,'$$|fit-man-at-all-am-not,']
[$ennu$|$$ennu$$|saying] [$pa.ra~n~nu.$|$$pa.ra~n~nu.$$|said.]
%
[$ennaa.re$|$$^ennaa.re$$|But] [$appan$|$$appan$$|the-father]
[$tan.re$|$$tan.re$$|his] [$daasaroo.tu,$|$$daasaroo.tu,$$|slaves-to,]
[$`veekam$|$$`vegam$$|`quickly]
[$meelttaramaaya$|$$meel-ttaram-aaya$$|high-class-being]
[$a"nki$|$$a"ngi$$|robe]
[$ko.n.tuvannu$|$$ko.n.du-vannu$$|having-taken-having-come]
[$ivane$|$$ivane$$|him] [$u.tuppippin,$|$$u.duppippin,$$|dress-ye,]
[$keikku$|$$keikku$$|hand-on] [$moodiravum$|$$moodirav-um$$|ring-and]
[$kaaluka.lkku$|$$kaaluga.lkku$$|feet-on]
[$cerippuka.lum$|$$cerippuga.lum$$|shoes-and]
[$i.tuvippin.$|$$i.duvippin.$$|put-ye.]
%
[$naam$|$$^naam$$|We] [$bhak.siccu$|$$bhak.siccu$$|eating]
[$aanandikka.$|$$aanandikka.$$|shall-feast.]
%
[$ii$|$$^ii$$|This] [$en.re$|$$en.re$$|my] [$makan$|$$magan$$|son]
[$mariccavan$|$$mariccavan$$|dead-man]
[$aayirunnu,$|$$aay-irunnu,$$|having-become-is,]
[$tirikee$|$$tirigee$$|again] [$uyirttu;$|$$uyrittu;$$|revived;]
[$kaa.naate$|$$kaa.naade$$|not-seeing] [$pooyavan$|$$pooyavan$$|gone-man]
[$aayirunnu,$|$$aay-irunnu,$$|having-become-is,]
[$ka.n.tuki.t.takayum$|$$ka.n.duki.t.tagayum$$|seeing-finding]
[$ceytuvalloo?'$|$$ceydu-v-alloo?'$$|made-is-it-not?']
[$ennu$|$$ennu$$|saying] [$pa.ra~n~nu.$|$$pa.ra~n~nu.$$|said.]
%
[$avar$|$$^avar$$|They] [$aanandiccu$|$$aanandiccu$$|feasting]
[$tu.ta"n"ni.$|$$tu.da"n"ni.$$|began.]


[$ennaal$|$$^ennaal$$|Now] [$avan.re$|$$avan.re$$|his]
[$muutta$|$$muutta$$|elder] [$makan$|$$magan$$|son]
[$vayalil$|$$vayalil$$|field-in] [$aayirunnu,$|$$aay-irunnu,$$|had-been,]
[$aayavan$|$$aay-avan$$|having-become-he] [$vannu$|$$vannu$$|coming]
[$vii.t.tinoo.tu$|$$vii.t.tinoo.du$$|house-to]
[$a.tuttappoo.l$|$$a.duttappoo.l$$|coming-when]
[$vaadyavum$|$$vaadyav-um$$|music-and]
[$nRttaghoo.sa"n"na.lum$|$$nRttaghoo.sa"n"na.l-um$$|dancing-sounds-and]
[$kee.t.tu$|$$kee.t.tu$$|hearing]
[$baalyakkaaril$|$$baalya-kkaaril$$|servants-among]
[$oruttane$|$$oruttane$$|one] [$vi.liccu,$|$$vi.liccu,$$|calling,]
[$`itentu?'$|$$`id-endu?'$$|`this-what?'] [$ennu$|$$ennu$$|saying]
[$coodiccu.$|$$coodiccu.$$|asked.]
%
[$avan$|$$^avan$$|he] [$avanoo.tu$|$$avanoo.du$$|him-to]
[$pa.ru~n~nu,$|$$pa.ru~n~nu,$$|said,] [$`nin.re$|$$`nin.re$$|`thy]
[$sahoodaran$|$$sahoodaran$$|brother] [$vannu$|$$vannu$$|coming]
[$`nin.re$|$$`nin.re$$|`thy] [$appan$|$$appan$$|father]
[$avane$|$$avane$$|him] [$saukhyattoo.te$|$$saukhyattoo.de$$|healthy]
[$ki.t.tiyatuko.n.tu$|$$ki.t.tiyadu-ko.n.du$$|finding-on-account-of]
[$virunnu$|$$virunnu$$|feast] [$kazhiccu.'$|$$kazhiccu.'$$|made.']
%
[$appoo.l$|$$^appoo.l$$|Then] [$avan$|$$avan$$|he]
[$koopiccu$|$$koopiccu$$|getting-angry] [$akam$|$$agam$$|house]
[$bukavaan$|$$bugavaan$$|to-enter]
[$manassillaa~n~nu,$|$$manass-illaa~n~nu,$$|mind-was-not,]
[$enni.t.tu$|$$enni.t.tu$$|having said] [$appan$|$$appan$$|the-father]
[$pu.rattu$|$$pu.rattu$$|out] [$vannu$|$$vannu$$|having-come]
[$avanoo.tu$|$$avanoo.du$$|him-with]
[$apeek.siccu.$|$$apeek.siccu.$$|entreated.]
%
[$ennaa.re$|$$^ennaa.re$$|But] [$avan$|$$avan$$|he]
[$avanoo.tu,$|$$avanoo.du,$$|him-to,]
[$`ka.n.taalum,$|$$`ka.n.d-aalum,$$|`see-please,] [$itra$|$$itra$$|so-many]
[$var.samaayi$|$$var.sam-aayi$$|years-having-become]
[$~naan$|$$~naan$$|I] [$ninne$|$$ninne$$|thee]
[$seevikkunnu.$|$$seevikkunnu.$$|serve.]
%
[$nin.re$|$$^nin.re$$|Thy] [$kalpana$|$$kalpana$$|order]
[$oru$|$$oru$$|one] [$naa.lum$|$$naa.l-um$$|day-even]
[$la.mghiccatum$|$$la"nghiccad-um$$|transgressing-even]
[$illa,$|$$illa,$$|was-not,] [$ennaal$|$$ennaal$$|but] [$en.re$|$$en.re$$|my]
[$ca"n"naatika.lumaayi$|$$ca"n"naatika.lum-aayi$$|friends-with-having-become]
[$aanandikkee.n.tatinnu$|$$aanandikk-ee.n.dadinnu$$|to-feast-wanted-being-for]
[$nii$|$$nii$$|thou] [$orikkalum$|$$orikkal-um$$|once-even]
[$enikku$|$$enikku$$|me-to] [$or$|$$or$$|one]
[$aa.t.tinku.t.ti$|$$aa.t.tinku.t.ti$$|kid]
[$tanni.t.tilla.$|$$tann-i.t.t-illa.$$|gavest-not.]
%
[$veeshyamaaro.tu$|$$^veeshyamaaro.du$$|Harlots-with]
[$kuu.ti$|$$kuu.di$$|joining] [$nin.re$|$$nin.re$$|thy]
[$mutal$|$$mudal$$|property] [$tinnu$|$$tinnu$$|eating]
[$ka.la~n~na$|$$ka.la~n~na$$|having-wasted] [$ii$|$$ii$$|this]
[$nin.re$|$$nin.re$$|thy] [$makan$|$$magan$$|son]
[$vannappoozhekkoo$|$$vann-appoozhekkoo$$|coming-when]
[$avannaayi$|$$avann-aayi$$|him-for] [$virunnu$|$$virunnu$$|feast]
[$kazhiccuvalloo?'$|$$kazhiccuv-alloo?'$$|madest-is-it-not?']
[$ennu$|$$ennu$$|saying] [$uttaram$|$$uttaram$$|reply]
[$colli.$|$$colli.$$|spoke.]
%
[$appoo.l$|$$^appoo.l$$|Then] [$avan$|$$avan$$|he]
[$avanoo.tu$|$$avanoo.du$$|him-to] [$pa.ra~n~nu,$|$$pa.ra~n~nu,$$|said,]
[$`makanee,$|$$`magan-ee,$$|`son-O,] [$nii$|$$nii$$|thou]
[$eppoozhum$|$$eppoozh-um$$|always] [$ennoo.tu$|$$ennoo.du$$|me-with]
[$ku.te$|$$ku.de$$|together]
[$aakunnuvalloo?'$|$$aagunnuv-alloo?'$$|art-is-it-not?']
[$enikku.l.latu$|$$enikk-u.l.ladu$$|me-to-being-that]
[$ellaam$|$$ellaam$$|all] [$nin.ree.tu$|$$nin.ree.du$$|thine]
[$aakunnu.$|$$aagunnu.$$|is.]
%
[$ennaal$|$$^ennaal$$|But] [$ii$|$$ii$$|this] [$nin.re$|$$nin.re$$|thy]
[$sahoodaran$|$$sahoodaran$$|brother] [$mariccavan$|$$mariccavan$$|dead-man]
[$aayirunnu$|$$aay-irunnu$$|had-become]
[$tirikee$|$$tirigee$$|again] [$uyirttu;$|$$uyirttu;$$|revived;]
[$kaa.naate$|$$kaa.naade$$|not-seeing] [$pooyavan$|$$pooyavan$$|goer]
[$aayirunnu,$|$$aay-irunnu,$$|had-become,]
[$ka.n.tuki.t.tiyirikkayaal$|$$ka.n.du-ki.t.tiy-irikkayaal$$|seeing-reaching-being-because]
[$naam$|$$naam$$|we] [$aanandiccu$|$$aanandiccu$$|having-been-merry]
[$santoo.sikkee.n.tatalloo?$|$$santoo.sikk-ee.n.dadalloo?$$|to-feast-wanted-being-is-it-not?]
[$aakunnu.'$|$$aagunnu.'$$|is.']


\endthreelines

\bye
